function Test() {
   alert("AcMap.js");
}

function Highlight(Elem, Color) {
   // Applies hand pointer, underline, and color (optional) to Elem.
   // Elem   Element to be highlighted
   // Color  0 = No color change
   //        Any other integer or omitted = Color change
   // Works with UnHighlight function.
   Elem.style.cursor = "hand";
   if (Color != 0) {
      Elem.style.color = "#33c";
   }
   Elem.style.textDecoration = "underline";
}

function UnHighlight(Elem, Color) {
   // Removes hand pointer, underline, and color (optional) from Elem, but
   // only if they were set programatically, and restores these settings to
   // underlying values set by stylesheet or Style attribute.
   // Elem   Element to be un-highlighted
   // Color  0 = No color change
   //        Any other integer or omitted = Color change
   // Works with UnHighlight function.
   Elem.style.cursor = "";
   if (Color != 0) {
      Elem.style.color = "";
   }
   Elem.style.textDecoration = "none";
}

function MakeVisible(Context, Head, Body) {
   // On event in Head, makes Body visible, makes all other Bodies
   // invisible, undoes color change and underline in all other Heads.
   // Action restricted to scope of Context.
   // Context  ID of Div to which the action of this function is restricted
   // Head     ID of the trigger element, or "this"
   // Body     ID of the element to be made visible
   //
   // For each element in Context
   for (i = 0; i < Context.all.length; i++) {
      with (Context.all[i].style) {
         ThisId = Context.all[i].id + ""
         // If it's a head
         if (ThisId.charAt(0) == "A") {
            textDecoration = "none";
            color="#306";
         }
         // If it's a body
         if (ThisId.charAt(0) == "B") {
            visibility = "hidden";
         }
      }
   }
   with (Head.style) {
      textDecoration = "underline";
      color = "#39f";
   }
   Body.style.visibility = "visible";
}

function Display(Context, Head, Body, Image) {
   // On click in Head, makes Body display, makes all other Bodies
   // not display, undoes color change and underline in all other Heads.
   // Action restricted to scope of Context.
   // Context  ID of Div to which the action of this function is restricted
   // Head     ID of the trigger element, or "this"
   // Body     ID of the element to display
   // Image    ID of the "open/closed" image element associated with Head
   // You can call this function without the last parameter if there is
   // no "open/closed" image element.
   if (Body.style.display == "block") {
      Body.style.display = "none";
      Image.src = "Closed.gif";
   }
   else {
      // For each element in Context
      for (i = 0; i < Context.all.length; i++) {
         with (Context.all[i]) {
            ThisId = Context.all[i].id + ""
            // If it's a head
            if (ThisId.charAt(0) == "M") {
               // Do nothing
            }
            // If it's a body
            if (ThisId.charAt(0) == "N") {
               style.display = "none";
            }
            // If it's an open-closed image
            if (ThisId.charAt(0) == "i") {
               src = "Closed.gif";
            }
         }
      }
      Body.style.display = "block";
      Image.src = "Open.gif";
   }
}

function DisplayComment(Context, Head, Body, Image) {
   // On mouse-over in Head, makes Body display, makes all other Bodies
   // not display, undoes color change and underline in all other Heads.
   // Action restricted to scope of Context.
   // Context  ID of Div to which the action of this function is restricted
   // Head     ID of the trigger element, or "this"
   // Body     ID of the element to display
   // Image    ID of the "open/closed" image element associated with Head
   // You can call this function without the last parameter if there is
   // no "open/closed" image element.
   //
   // Reset each element in Context
   for (i = 0; i < Context.all.length; i++) {
      with (Context.all[i]) {
         ThisId = Context.all[i].id + ""
         // If it's a head
         if (ThisId.charAt(0) == "A") {
            // Do nothing
         }
         // If it's a body
         if (ThisId.charAt(0) == "B") {
            style.display = "none";
         }
         // If it's an open-closed image
         if (ThisId.charAt(0) == "i") {
            src = "Closed.gif";
         }
      }
   }
   Body.style.display = "block";
   Image.src = "Open.gif";
}

var newWin;  // New window defined by the OpenWindow function
function OpenWindow(Url)
// Opens a file in a new window with parameters hard-coded within the function.
// Url     URL of the file to open in the new window
{
    newWin = window.open(url,"CodeWin","scrollbars,resizable,width=550,height=400");
    newWin.focus();
}

function ShowHide(Elem) {
// Simple show-hide as with inline popups
// Elem   ID of element to show or hide
   if (Elem.style.display == "block") {
      Elem.style.display = "none";
   }
   else {
   Elem.style.display = "block";
   }
}

// Builds a ShortCut object to launch a CHM (with local path)
// build_hhrun_object -
//
function build_hhrun_object(file) {
  var path = location.pathname;
  var i = path.lastIndexOf("\\");
  var j = path.indexOf(":", 3);
  path = path.substring(j+1,i+1);
  document.writeln("<OBJECT id=hhrun type='application/x-oleobject'");
  document.writeln("  classid='clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11'");
  document.writeln("  codebase='hhctrl.ocx#Version=4,73,8561,0'>");
  document.writeln(" <PARAM name='Command' value='ShortCut'>");
  document.writeln(" <PARAM name='Item1' value=',hh.exe," + path + file + "'>");
  document.writeln(" <PARAM name='Window'  value='bogus.html'>");
  document.writeln("</OBJECT>");
}

function set_browse_buttons(show) {

// if the current record contains a show code
// (three digits, each 0  or 1, specifying if
// the corresponding browse button is on or off)
if (show != "")
   {
      // make browse button group visible
      document.all.head_nav.style.visibility = "visible";
      // show or hide buttons according to their show codes
      if (show.charAt(0) != 1)
         document.all.nav_prev.outerHTML = "";
         // document.all.nav_prev.outerHTML = "<img src='graphics/nav-prev-xp-o.gif' border='0'>";
         // document.all.nav_prev.style.visibility = "hidden";
      if (show.charAt(1) != 1)
         document.all.nav_up.outerHTML = "";
         // document.all.nav_up.outerHTML = "<img src='graphics/nav-up-xp-o-2.gif' border='0'>";
         // document.all.nav_up.style.visibility = "hidden";
      if (show.charAt(2) != 1)
         document.all.nav_next.outerHTML = "";
         // document.all.nav_next.outerHTML = "<img src='graphics/nav-next-xp-o.gif' border='0'>";
         // document.all.nav_next.style.visibility = "hidden";
   }
}


// data-binding function for ref topics
function ChangeRecord(LinkTextObj, ListObj) {
   var FilterExpr = "";
   FilterExpr = "Command=" + LinkTextObj.id;
   commands.object.Filter = FilterExpr;
   commands.Reset();
   for (var i = 0; i < ListObj.all.length; i++) {
      ListObj.all[i].style.color = "#57b";
   }
   LinkTextObj.style.color = "#137";
   LinkTextObj.style.textDecoration = "none";
}



//-------------------------------------------
// Added by IntelliArts
//-------------------------------------------
function swapImage(theImgObj, theImage1, theImage2) {
    if (theImgObj.src.search(trimRelativePath(theImage1)) > 0 || theImage1 == theImgObj.src) {
        theImgObj.src = theImage2
    } else {
        theImgObj.src = theImage1
    }
}

function showExpandedImage(theImgObj, theImage) {
    if (theImgObj.src != theImage) {
        theImgObj.src = theImage;
    }
}

function trimRelativePath(path) {
    if (path.indexOf('./') == 0) {
        return trimRelativePath(path.substring(2));
    } else if (path.indexOf('../') == 0) {
        return trimRelativePath(path.substring(3));
    } else if (path.indexOf('../') > 0) {
        if (path.indexOf('/') < path.indexOf('../')) {
            return trimRelativePath(path.substring(0,path.indexOf('/'))+path.substring(path.indexOf('../')+3));
        } else return path;
    } else {
        return path;
    }
}

function showHide(theId) {
    if (document.getElementById) { // DOM3 = IE5, NS6
        el = document.getElementById(theId)
        if (el.style.display == 'none') {
            showElement(el)
        }
        else {
            hideElement(el)
        }
    }
}

function showBlock(theId) {
    if (document.getElementById) { // DOM3 = IE5, NS6
        el = document.getElementById(theId)
        if (el.style.display == 'none') {
            showElement(el)
        }
    }
}

function hideElement(theEl) {
    theEl.style.display = 'none';
}
function showElement(theEl) {
    theEl.style.display = '';
}

function linkParser(fn) {
    var X, Y, sl, a, ra, link;
    ra = /:/;
    a = location.href.search(ra);
    if (a == 2)
    X = 14;
    else
    X = 7;
    sl = "\\";
    Y = location.href.lastIndexOf(sl) + 1;
    var tmpRes = location.href.substring(X, Y) + fn;
    if (!(location.href.search('file:///') >= 0))
        tmpRes = 'file:///' + tmpRes;
    return tmpRes;
}

function linkHelpFile(fn, tn) {
    var fileUrl = linkParser(fn);
    var tmpRes = 'mk:@MSITStore:' + fileUrl;
    if (tn != null)
        tmpRes += '::/' + tn;
    return tmpRes;
}

//-------------------------------------------
//ExpandAll CollapseAll scripts
try {
// trying to add Mozzila event listener
    window.addEventListener("load",CheckForCollapsible, true);
} catch (e) {
// wrong adding IE event
    window.attachEvent("onload",CheckForCollapsible);

}


//addLoadEvent(CheckForCollapsible);

/* essential global variables */
var divPattern;
var els;
var elsLen;
var collapseExists = false;
var collapseSection;
var expandSection;
var collapsedImagePath;
var expandedImagePath;

function CheckForCollapsible() {

    divPattern = new RegExp(/collapsible\w+/);
    els = document.getElementsByTagName('div');
    elsLen = els.length;
    collapseSection = document.getElementById("collapseAllSection");
    expandSection = document.getElementById("expandAllSection");

    var i = 0;
    while (i < elsLen && !collapseExists) {
        if (divPattern.test(els[i].getAttribute("id")))
            collapseExists = true;
        i++;
    }

    if (collapseExists) {
        expandSection.style.display = "block";
        try {
            collapsedImagePath = document.getElementById("collapse_img").src;
            expandedImagePath = document.getElementById("expand_img").src;
        } catch( e) {

        }
    }

}   // function CheckForCollapsible()

function swapLabel()
{
    if (collapseSection.style.display == "block")
    {
        collapseSection.style.display = "none";
        expandSection.style.display = "block";
    } else {
        collapseSection.style.display = "block";
        expandSection.style.display = "none";
    }
}

function ExpandOrCollapse()
{

    var imgPattern = new RegExp(/d\w+/);
    var imgID = document.getElementsByTagName('img');
    var imgIDLen = imgID.length;

    for (i = 0; i < elsLen; i++) {
        if ( divPattern.test(els[i].getAttribute("id")) ) {
            ShowHide(els[i]);
        }
    }

    for (j = 0; j < imgIDLen; j++) {
        if ( imgPattern.test(imgID[j].getAttribute("id")) ) {
            swapImage(imgID[j], expandedImagePath, collapsedImagePath);
        }
    }

    swapLabel();
}

function ExpandAll()
{

    var imgPattern = new RegExp(/d\w+/);
    var imgID = document.getElementsByTagName('img');
    var imgIDLen = imgID.length;
    var elID;

    for (i = 0; i < elsLen; i++) {
        if ( divPattern.test(els[i].getAttribute("id")) ) {
            elID = els[i].getAttribute("id");
            showBlock(elID);
        }
    }

    for (j = 0; j < imgIDLen; j++) {
        if ( imgPattern.test(imgID[j].getAttribute("id")) ) {
            showExpandedImage(imgID[j], expandedImagePath);
        }
    }

    swapLabel();
}

function CollapseAll() {

    window.location.reload();

}

// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEBpf
// SIG // 3lTuSWeoEO3WfiGLYKqgggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQ2X4P
// SIG // JMK8bWmR6/zYhVhYxzBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAen56/3b8x5dXsbXCRcEw
// SIG // baTzwDDCa/pRIS9xsJqxjHxms0hzgAI3BT2109Uxtp6Q
// SIG // 0nWMIgDR/eyVS9KUOLP/umKCPPdBqk1/kz/DU6+2+EIA
// SIG // quwNYaCgYtJ5VhfgyqkNHdLB+Sx5jCWpRMbNGvrE+OI5
// SIG // nQrRgC9LLLL7aZ/LJo4=
// SIG // End signature block
